﻿namespace St0rm.MapDownloader
{
    using BitFlex.Windows.Forms;

    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Data;
    using System.Drawing;
    using System.Linq;
    using System.Text;
    using System.Windows.Forms;

    public partial class MainForm : Form
    {
        #region Singleton
        public static MainForm Instance;
        #endregion

        #region Constructors
        public MainForm()
        {
            InitializeComponent();
        }
        #endregion

        #region Events

        private void FrmMain_Load(object sender, EventArgs e)
        {
            uxGameDataDirectory.Text = Config.InstallDirectory;
            uxBrowseNewDirectory.Click += (s, evt) =>
            {
                uxInstallDirectoryBrowse.RootFolder = Environment.SpecialFolder.MyComputer;

                if (uxInstallDirectoryBrowse.ShowDialog() == DialogResult.OK)
                {
                    uxGameDataDirectory.Text = uxInstallDirectoryBrowse.SelectedPath;
                    Config.InstallDirectory = uxInstallDirectoryBrowse.SelectedPath;
                }
            };
        }

        private void btnDownload_Click(object sender, EventArgs e)
        {
            List<Map> toDownload = new List<Map>();
            for (int i = 0; i < uxAvailableMaps.Items.Count; i++)
            {
                if (uxAvailableMaps.GetItemChecked(i))
                {
                    toDownload.Add((Map)uxAvailableMaps.Items[i]);
                }
            }
            Downloadable(false);
            System.Threading.ThreadPool.QueueUserWorkItem(x => FtpManager.Instance.DownloadAll(toDownload));
        }

        private void FrmMain_FormClosing(object sender, FormClosingEventArgs e)
        {
            Application.Exit();
        }

        private void uxGameMapsLink_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("http://www.game-maps.net");
        }

        private void uxSelectAll_Click(object sender, EventArgs e)
        {
            for (int i = 0; i < uxAvailableMaps.Items.Count; i++)
            {
                if (!uxAvailableMaps.GetItemChecked(i))
                {
                    uxAvailableMaps.SetItemChecked(i, true);
                }
            }
        }

        private void uxDeselectAll_Click(object sender, EventArgs e)
        {
            for (int i = 0; i < uxAvailableMaps.Items.Count; i++)
            {
                if (uxAvailableMaps.GetItemChecked(i))
                {
                    uxAvailableMaps.SetItemChecked(i, false);
                }
            }
        }

        #endregion

        #region Properties

        public CheckedListBox MapList
        {
            get
            {
                return uxAvailableMaps;
            }
        }

        public String Status
        {
            set
            {
                uxCurrentStatus.Invoke((Action)(() => uxCurrentStatus.Text = value));
            }
        }

        #endregion

        #region Methods

        public void SetFileBar(int value)
        {
            if (uxCurrentProgress.InvokeRequired)
            {
                uxCurrentProgress.Invoke(new System.Threading.ThreadStart(() => { uxCurrentProgress.Value = value; }));
                uxCurrentProgress.Invoke(new System.Threading.ThreadStart(() => { uxCurrentProgress.StatusText = String.Format("{0}%", value); }));
            }
            else
            {
                uxCurrentProgress.Value = value;
                uxCurrentProgress.StatusText = String.Format("{0}%", value);
            }
        }

        public void SetTotalBar(int value)
        {
            if (uxTotalProgress.InvokeRequired)
            {
                uxTotalProgress.Invoke(new System.Threading.ThreadStart(() => { uxTotalProgress.Value = value; }));
                uxTotalProgress.Invoke(new System.Threading.ThreadStart(() => { uxTotalProgress.StatusText = String.Format("{0}%", value); }));
            }
            else
            {
                uxTotalProgress.Value = value;
                uxTotalProgress.StatusText = String.Format("{0}%", value);
            }

        }

        public void Downloadable(bool truefalse)
        {
            if (uxDownloadMaps.InvokeRequired)
            {
                uxDownloadMaps.Invoke(new System.Threading.ThreadStart(() => uxDownloadMaps.Enabled = true));
            }
            else
            {
                uxDownloadMaps.Enabled = truefalse;
            }
            uxBrowseNewDirectory.Invoke((Action)(() => uxBrowseNewDirectory.Enabled = truefalse));
            uxAvailableMaps.Invoke((Action)(() => uxAvailableMaps.Enabled = truefalse));
        }

        protected override void WndProc(ref Message m)
        {
            base.WndProc(ref m);
        }

        #endregion
    }
}
